﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class FSKGen : UserControl
    {
        private FSKGenerator FSK = null;


        public FSKGen()
        {
            InitializeComponent();

            // Iniatialize the default FSK signal settings
            FSKPhysicalSettings S = FSKPhysicalSettings.GetDefaults(CallerIDStandardBody.TIA_Telecordia, SignalLevel.InVrms(0.1));
            level_Mark.Level = S.MarkLevel;
            level_Space.Level = S.SpaceLevel;
            freq_Mark.Freq = S.MarkFrequency;
            freq_Space.Freq = S.SpaceFrequency;
            freq_Baud.Freq = S.Baud;

            cbo_VMWI.Items.Clear();
            cbo_VMWI.Items.Add(true);
            cbo_VMWI.Items.Add(false);
            cbo_VMWI.SelectedIndex = 0;


            cbo_MessageFormat.Items.Clear();
            cbo_MessageFormat.Items.Add("MDMF");
            cbo_MessageFormat.Items.Add("SDMF");
            cbo_MessageFormat.SelectedIndex = 0;

            

        }

        public void SetGenerator(FSKGenerator FSK)
        {
            this.FSK = FSK;
            btn_Generate.Enabled = true;
            cbo_DisableFSKRx.Checked = FSK.DisableFSKReceiverDuringTransmissions;
        }



        private void FSKGenCtrl_Load(object sender, EventArgs e)
        {
    
        
        }

        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                // construct the FSK signalling settings
                FSKPhysicalSettings Phys = new FSKPhysicalSettings(level_Mark.Level,
                                                                level_Space.Level,  
                                                                freq_Mark.Freq,
                                                                freq_Space.Freq,
                                                                freq_Baud.Freq);
                                                                         


                // Construct the Caller ID message which will make up the data portion of the message
                FSKCallerIDData Msg;

                FSK.DisableFSKReceiverDuringTransmissions = cbo_DisableFSKRx.Checked;

                if (cbo_MessageFormat.Text == "MDMF")
                {
                    if (rb_CallSetup.Checked)
                    {
                        Msg = TIA.CallSetupMessage(CallerIDDateTime.Now(), txt_CallingName.Text, txt_CallingNumber.Text);

                    }
                    else
                    {

                        Msg = TIA.MDMF_VMWI_Message((bool)cbo_VMWI.SelectedItem);
                    }
                }
                else
                {
                    if (rb_CallSetup.Checked)
                    {
                        Msg = TIA.CallingNumberDeliveryMessage(CallerIDDateTime.Now(), txt_CallingNumber.Text);

                    }
                    else
                    {

                        Msg = TIA.SDMF_VMWI_Message((bool)cbo_VMWI.SelectedItem);
                    }
                }
                
                int CSBits=0;
                int MarkBits=180;
                int StopBits=1;
                int MarkOut =3;

                if (!int.TryParse(txt_CSBits.Text,out CSBits)) throw new Exception("Invalid channel seizure value");
                if (!int.TryParse(txt_Markbits.Text,out MarkBits)) throw new Exception("Invalid mark  bits value");
                if (!int.TryParse(txt_Stopbits.Text, out StopBits)) throw new Exception("Invalid stop bits value");
                if (!int.TryParse(txt_MarkOut.Text,out MarkOut)) throw new Exception("Invalid mark out value");
                
                // Now we create a fully specified FSK Caller ID transmission specification
                FSKCallerIDTransmission TX = new FSKCallerIDTransmission(Msg, CSBits, MarkBits, StopBits, MarkOut, Phys);

                
                // Now we instruct the signal generator to send this message 
                FSK.Generate(TX);


            }
            catch (Exception ex)
            {   
                MessageBox.Show(ex.Message);
            }
        }
    }
}
